<?php
/* ==================== Подключение файлов  ===================== --> */
require_once 'classes/clean.php';

/* ==================== Определяет размеры изображений  ===================== --> */
add_image_size('capture_point_1920', 350, 350, true);
add_image_size('capture_point_1024', 150, 150, true);
add_image_size('first-screen_1920', 1920, 945, true);
add_image_size('first-screen_1024', 1024, 600, true);
add_image_size('value_1920', 1840, 624, true);
add_image_size('value_1024', 924, 314, true);
add_image_size('partners_1920', 1920, 681, true);
add_image_size('partners_1024', 1024, 506, true);
add_image_size('staff_1920', 445, 528, true);
add_image_size('staff_1024', 355, 420, true);
add_image_size('news_home_1920', 755, 671, true);
add_image_size('news_home_1024', 472, 466, true);
add_image_size('categories-thumbnail-1920', 1920, 385, true);
add_image_size('offer-1920', 1162, 1080, true);
add_image_size('offer-1024', 620, 577, true);
add_image_size('offer-background-1920', 1920, 1144, true);
add_image_size('offer-background-1024', 1024, 810, true);
add_image_size('categories-thumbnail-full-1920', 445, 368, true);
add_image_size('categories-thumbnail-full-1024', 472, 315, true);
add_image_size('article-image-1920', 635, 498, true);
add_image_size('article-image_2-1920', 1840, 624, true);
add_image_size('article-image_2-1024', 1024, 533, true);
add_image_size('product-thumbnail-1920', 444, 518, true);
add_image_size('product-gallery-1920', 600, 434, true);
add_image_size('product-gallery-1024', 472, 341, true);
add_image_size('product-gallery-full-1920', 1200, 860, true);

/* ==================== Отключаем обновления Wordpress  ===================== --> */
add_filter('pre_site_transient_update_core',create_function('$a', "return null;"));
wp_clear_scheduled_hook('wp_version_check');

remove_action('load-update-core.php','wp_update_themes');
add_filter('pre_site_transient_update_themes',create_function('$a', "return null;"));
wp_clear_scheduled_hook('wp_update_themes');

remove_action( 'load-update-core.php', 'wp_update_plugins' );
add_filter( 'pre_site_transient_update_plugins', create_function( '$a', "return null;" ) );
wp_clear_scheduled_hook( 'wp_update_plugins' );

/* ==================== Регистрация меню ===================== --> */
add_action( 'after_setup_theme', 'theme_register_nav_menu' );

function theme_register_nav_menu() {
	register_nav_menu( 'main', 'Main Menu' );
}

/* ==================== Добавляет тип записи - Новости ===================== --> */

function rename_posts_labels($labels)
{
   /* оригинал
		stdClass Object (
			'name'                  => 'Записи',
			'singular_name'         => 'Запись',
			'add_new'               => 'Добавить новую',
			'add_new_item'          => 'Добавить запись',
			'edit_item'             => 'Редактировать запись',
			'new_item'              => 'Новая запись',
			'view_item'             => 'Просмотреть запись',
			'search_items'          => 'Поиск записей',
			'not_found'             => 'Записей не найдено.',
			'not_found_in_trash'    => 'Записей в корзине не найдено.',
			'parent_item_colon'     => '',
			'all_items'             => 'Все записи',
			'archives'              => 'Архивы записей',
			'insert_into_item'      => 'Вставить в запись',
			'uploaded_to_this_item' => 'Загруженные для этой записи',
			'featured_image'        => 'Миниатюра записи',
			'set_featured_image'    => 'Задать миниатюру',
			'remove_featured_image' => 'Удалить миниатюру',
			'use_featured_image'    => 'Использовать как миниатюру',
			'filter_items_list'     => 'Фильтровать список записей',
			'items_list_navigation' => 'Навигация по списку записей',
			'items_list'            => 'Список записей',
			'menu_name'             => 'Записи',
			'name_admin_bar'        => 'Запись',
		)
	*/

   $new = array(
      'name'                  => 'Каталог',
      'singular_name'         => 'Каталог',
      'add_new'               => 'Добавить новый',
      'add_new_item'          => 'Добавить товар',
      'edit_item'             => 'Редактировать товар',
      'new_item'              => 'Новый товар',
      'view_item'             => 'Просмотреть товар',
      'search_items'          => 'Поиск товара',
      'not_found'             => 'Товаров не найдено.',
      'not_found_in_trash'    => 'Товаров в корзине не найдено.',
      'parent_item_colon'     => '',
      'all_items'             => 'Все товары',
      'archives'              => 'Архивы товаров',
      'insert_into_item'      => 'Вставить в товар',
      'uploaded_to_this_item' => 'Загруженные для этого товара',
      'featured_image'        => 'Миниатюра товара',
      'filter_items_list'     => 'Фильтровать список товаров',
      'items_list_navigation' => 'Навигация по списку товаров',
      'items_list'            => 'Список товаров',
      'menu_name'             => 'Каталог',
      'name_admin_bar'        => 'Товар', // пункте "добавить"
   );

  return (object) array_merge((array) $labels, $new);
}
add_filter('post_type_labels_post', 'rename_posts_labels');

/* ==================== Добавляет тип записи - Новости ===================== --> */
function webpro_create_news_posttype()
{
  $labels = array(
    'name' => _x('Новости', 'Тип записи Новости'),
    'singular_name' => _x('Новость', 'Тип записи Новость'),
    'menu_name' => __('Новости'),
    'all_items' => __('Все Новости'),
    'view_item' => __('Смотреть Новость'),
    'add_new_item' => __('Добавить Новость'),
    'add_new' => __('Добавить новость'),
    'edit_item' => __('Редактировать'),
    'update_item' => __('Обновить'),
    'search_items' => __('Искать'),
    'not_found' => __('Не найдено'),
    'not_found_in_trash' => __('Не найдено'),
  );

  $args = array(
    'label' => __('news'),
    'description' => __('Каталог Новостей'),
    'labels' => $labels,
    'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields',),
    'has_archive' => true,
    'taxonomies' => array('your_taxonomy'),
    'hierarchical' => false,
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'show_in_nav_menus' => true,
    'show_in_admin_bar' => true,
    'menu_position' => 4,
    'menu_icon' => 'dashicons-format-aside',
    'can_export' => true,
    'has_archive' => true,
    'exclude_from_search' => false,
    'publicly_queryable' => true,
    'capability_type' => 'page',
    'show_in_rest' => 'true'
  );

  register_post_type('news', $args);
}
add_action('init', 'webpro_create_news_posttype', 1);


/* ==================== Добавляет стандартный вывод для медиафайлов, вместо id ===================== --> */
add_filter( 'acf/settings/rest_api_format', function () {
  return 'standard';
} );

/* ==================== API ===================== --> */
// Обработка изображений
function get_image ($image, $sizes) {
  $data = [
    source => []
  ];

  if($image) {
    if(is_array($sizes)) {
      if(count($sizes) === 1) {
        if(!empty($sizes[0]["media"]) && !empty($image['sizes'][$sizes[0]["name"]])) {
          $data['src'] = $image['sizes'][$sizes[0]["name"]];
          $data['width'] = $image['sizes'][$sizes[0]["name"].'-width'];
          $data['height'] = $image['sizes'][$sizes[0]["name"].'-height'];
          $data['alt'] = $image['alt'];
        }
      } else {
        foreach ($sizes as $key => $val) {
          if(!empty($val["media"]) && !empty($image['sizes'][$val["name"]])) {
              array_push($data['source'], ['src' => $image['sizes'][$val['name']],'width' => $image['sizes'][$val['name'].'-width'],'height' => $image['sizes'][$val['name'].'-height'], 'media' => $val['media']]);
            } else {
              $data['src'] = $image['sizes'][$val["name"]];
              $data['width'] = $image['sizes'][$val["name"].'-width'];
              $data['height'] = $image['sizes'][$val["name"].'-height'];
              $data['alt'] = $image['alt'];
            }
          }
        }
      }
    }

    if(empty($val["src"])) {
      $data['src'] = $image['url'];
      $data['width'] = $image['width'];
      $data['height'] = $image['height'];
      $data['alt'] = $image['alt'];
    }

    return $data;
}


function sanitize_data ($param) {
  return Clean::str($param);
}

// Регистрация маршрутов
add_action( 'rest_api_init', function() {
  register_rest_route( 'myplugin/v1', '/home-page/', [
		'methods' => 'GET',
		'callback' => 'home_page',
	]);
  register_rest_route( 'myplugin/v1', '/about-page/', [
		'methods' => 'GET',
		'callback' => 'about_page',
	]);
  register_rest_route( 'myplugin/v1', '/contacts-page/', [
		'methods' => 'GET',
		'callback' => 'contacts_page',
	]);
  register_rest_route( 'myplugin/v1', '/widget-page/', [
		'methods'  => 'GET',
		'callback' => 'widget_page',
	]);
  register_rest_route( 'myplugin/v1', '/catalog-page/', [
		'methods' => 'GET',
		'callback' => 'catalog_page',
	]);
  register_rest_route( 'myplugin/v1', '/news-page/', [
		'methods' => 'GET',
		'callback' => 'news_page',
	]);
  register_rest_route( 'myplugin/v1', '/product-category/', [
		'methods'  => 'GET',
		'callback' => 'product_category',
    'args'     => array(
      'slug' => array(
        'type' => 'string',
        'required',
        'sanitize_callback' => 'sanitize_data'
      ),
    ),
	]);
  register_rest_route( 'myplugin/v1', '/product-single/', [
		'methods'  => 'GET',
		'callback' => 'product_single',
    'args'     => array(
      'slug' => array(
        'type' => 'string',
        'required',
        'sanitize_callback' => 'sanitize_data'
      ),
    ),
	]);
  register_rest_route( 'myplugin/v1', '/product-list/', [
		'methods'  => 'GET',
		'callback' => 'product_list',
    'args'     => array(
      'page' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
      'per_page' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
      'category' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
      'type' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
      'regions' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
      'assembly_dates' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
    ),
	]);
  register_rest_route( 'myplugin/v1', '/news-single/', [
		'methods'  => 'GET',
		'callback' => 'news_single',
    'args'     => array(
      'slug' => array(
        'type' => 'string',
        'required',
      ),
    ),
	]);
  register_rest_route( 'myplugin/v1', '/news-list/', [
		'methods'  => 'GET',
		'callback' => 'news_list',
    'args'     => array(
      'page' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
      'per_page' => array(
        'type'     => 'string',
        'sanitize_callback' => 'sanitize_data'
      ),
    ),
	]);
});

// Получение категории
function product_category( WP_REST_Request $request ) {
  $data = [];

  if(empty($request -> get_param('slug'))) {
    return new WP_REST_Response($data->errors, 404);
  }

  $categories = get_categories( array(
    'taxonomy'     => 'category',
    'type'         => 'post',
    'slug'       => $request -> get_param('slug'),
  ));

  if(empty($categories)) {
    return new WP_REST_Response($data->errors, 404);
  }

  foreach( $categories as $category ) {
    if($category->term_id == 1) continue;

    $categoryHeader = get_field("offer", 'category_'.$category->term_id);
    $data['header']['data']['title'] = $categoryHeader['title'];
    $data['header']['data']['label'] = $categoryHeader['label'];
    $data['header']['data']['description'] = $categoryHeader['descriprion'];
    $data['header']['data']['link'] = [title => "Результаты демоиспытаний", url => $categoryHeader['file']];
    $data["header"]['data']["nameTitle"] = $category->name;

    $categoryAdvantages = get_field("advantages", 'category_'.$category->term_id);
    $data['info']['advantages']['is'] = $categoryAdvantages['is'];
    $data['info']['advantages']['title'] = $categoryAdvantages['title'];
    $data['info']['advantages']['description'] = $categoryAdvantages['descriprion'];
    $data['info']['advantages']['items'] = array_map(fn($i) => $i['text'], $categoryAdvantages['items']);

    $categoryClassification = get_field("classification", 'category_'.$category->term_id);
    $data['info']['classification']['is'] = $categoryClassification['is'];
    $data['info']['classification']['title'] = $categoryClassification['title'];
    $data['info']['classification']['description1'] = $categoryClassification['descriprion1'];
    $data['info']['classification']['description2'] = $categoryClassification['descriprion2'];
    $data['info']['classification']['link'] = $categoryClassification['file'];
    $data['info']['classification']['items'] = [];

    foreach ($categoryClassification['items'] as $key => $val) {
      array_push($data['info']['classification']['items'], [label => $val['abbreviation'], title => $val['name']]);
    }

    $categoryRegions = get_field("regions", 'category_'.$category->term_id);
    $data['info']['regions']['is'] = $categoryRegions['is'];
    $data['info']['regions']['title'] = $categoryRegions['title'];
    $data['info']['regions']['items'] = [];

    foreach ($categoryRegions['items'] as $key => $val) {
      $city = [];
      foreach ($val['items'] as $key => $sub_val) {
        array_push($city, $sub_val['name']);
      }

      array_push($data['info']['regions']['items'], [number => $val['number'], title => $val['name'], items => $city]);
    }

    $categoryCapturePoint = get_field("capture_point", 'category_'.$category->term_id);
    $data['info']['classification']['is'] = $categoryClassification['is'];
    $data['info']['classification']['title'] = $categoryClassification['title'];
    $data['info']['classification']['description1'] = $categoryClassification['descriprion1'];
    $data['info']['classification']['description2'] = $categoryClassification['descriprion2'];
    $data['info']['classification']['link'] = $categoryClassification['file'];
    $data['info']['classification']['items'] = [];

    foreach ($categoryClassification['items'] as $key => $val) {
      array_push($data['info']['classification']['items'], [label => $val['abbreviation'], title => $val['name']]);
    }

    // Capture Point
    $categoryCapturePoint = get_field("capture_point", 'category_'.$category->term_id);
    $data["capture_point"]["is"] = $categoryCapturePoint['is'];
    $data["capture_point"]["data"]["title"] = $categoryCapturePoint['title'];
    $data["capture_point"]["data"]["label"] = $categoryCapturePoint['label'];
    $data["capture_point"]["data"]["description"] = $categoryCapturePoint['subtitle'];
    $data["capture_point"]["data"]["button"] = $categoryCapturePoint['btn'];
    $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

    $data["capture_point"]["image"] = get_image($categoryCapturePoint['image'], [
      [name => 'capture_point_1920'],
      [name => 'capture_point_1024', media => "1023.98"],
    ]);

    // Meta Page
    $categoryMeta = get_field("meta_data", 'category_'.$category->term_id);
    $data["meta"] = $categoryMeta;
  }

  return $data;
}

// Получение списка товаров
function product_list( WP_REST_Request $request ) {
  $data = [];

  if(empty($request -> get_param('category'))) {
    return new WP_REST_Response($data->errors, 404);
  }

  // Получение параметров запроса
  $page = $request -> get_param('page')  ?? 1;
  $per_page = $request -> get_param('per_page')  ?? 12;
  $type = $request -> get_param('type');
  $regions = $request -> get_param('regions');
  $assembly_dates = $request -> get_param('assembly_dates');
  $category = $request -> get_param('category');

  // Формирование запрос
  $args = array(
    'post_type' => 'post',
    'posts_per_page' => $per_page,
    'paged' => $page,
    'category_name' => $category,
    'meta_query' => [],
  );

  if(!empty($type)) {
    array_push($args['meta_query'], [
      'key' => 'filter_type',
      'value' => $type,
      'compare' => 'LIKE'
    ]);
  }

  if(!empty($regions)) {
    array_push($args['meta_query'], [
      'key' => 'filter_regions',
      'value' => $regions,
      'compare' => 'LIKE'
    ]);
  }

  if(!empty($assembly_dates)) {
    array_push($args['meta_query'], [
      'key' => array('filter_assembly_dates'),
      'value' => $assembly_dates,
      'compare' => 'LIKE'
    ]);
  }

  // Получение записей
  $the_query = new WP_Query( $args );

  // Обрабатываем пагинацию
  $data['max_pages'] = (string) $the_query -> max_num_pages;
  $data['current_pages'] = $the_query -> max_num_pages >= $page ? $page : "0";
  $data['count'] = (string) $the_query -> found_posts;

  // Формирование записей
  $data['items'] = [];

  if ( $the_query->have_posts() ) {
    while ( $the_query->have_posts() ) {
      $the_query->the_post();

      $description = get_field("description");
      $preview = get_field('card');

      array_push($data['items'] , [
        'slug' => get_post_field('post_name'),
        'title' => $description['name'],
        'tags' => $description['metka'],
        'price' => $description['price'],
        'type' => $preview['description_1'],
        'collecting' => $preview['description_2'],
        'image' => get_image($preview['image'], [
          [name => 'product-thumbnail-1920']
        ]),
      ]);
    }
  } else {
    if(empty($search) && empty($tags)) {
      return new WP_REST_Response($data->errors, 404);
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение товара
function product_single( WP_REST_Request $request ) {
  $data = [];

  if(empty($request -> get_param('slug'))) {
    return new WP_REST_Response($data->errors, 404);
  }

  // Формируем данные
  $args = array(
    'name' => $request -> get_param('slug'),
    'post_type' => 'post',
  );

  $the_query = new WP_Query( $args );
  if ( $the_query->have_posts() ) {
    while ( $the_query->have_posts() ) {
      $the_query->the_post();

      // Header
      $data["header"]["nameTitle"] = get_the_title();

      // Info
      $description = get_field("description");
      $category = get_the_category();
      $brand = is_array($category) ? array_shift($category): [];

      $data["info"]["title"] = $description["name"];
      $data["info"]["description"] = $description["description"];
      $data["info"]["price"] = $description["price"];
      $data["info"]["brand"] = $brand -> name;
      $data["info"]["slug_brand"] = $brand -> slug;
      $data["info"]["link"] = $description["file"];
      $data["info"]["popup"] = $description["popup"];
      $data["info"]["protectant"] = [];

      foreach ($description["processing"] as $key => $val) {
        $item = explode(":", $val);
        array_push($data["info"]["protectant"], [label => $item[1],value => $item [0]]);
      }

      // Specifications
      $specifications = get_field("specifications");

      $data["properties"] = array();
      $data["properties"][] = [
        title => $specifications["title1"],
        items => [
          [ name => "Корнеплод", value => $specifications["root_vegetable"] ],
          [ name => "Листовая розетка", value => $specifications["leaf_socket"] ],
          [ name => "Сроки уборки", value => $specifications["cleaning_deadlines"] ],
          [ name => "Регионы допуска", value => $specifications["admission_regions"] ],
        ]
      ];
      $data["properties"][] = [
        title => $specifications["title2"],
        items => [
          [ name => "Потенциал урожайности", value => (int)$specifications["yield_potential"] ],
          [ name => "Сахаристость", value => (int)$specifications["sugar_content"] ],
          [ name => "Качество сока", value => (int)$specifications["juice_quality"] ],
          [ name => "Хранение", value => (int)$specifications["keeping"] ],
          [ name => "Пластичность гибрида", value => (int)$specifications["keeping"] ],
        ]
      ];
      $data["properties"][] = [
        title => $specifications["title3"],
        items => [
          [ name => "Афаномицес", value => (int)$specifications["aphanomyces"] ],
          [ name => "Фузариум", value => (int)$specifications["fusarium"] ],
          [ name => "Церкоспороз", value => (int)$specifications["cercosporosis"] ],
          [ name => "Мучнистая роса", value => (int)$specifications["powdery_mildew"] ],
          [ name => "Рамуляриоз", value => (int)$specifications["ramulariasis"] ],
          [ name => "Макрофомина", value => (int)$specifications["macrophomina"] ],
          [ name => "Ризоктония", value => (int)$specifications["rhizoctonia"] ],
        ]
      ];

      // Image
      $image = get_field("image");

      $data["image"] = [];

      foreach( $image as $item ) {
        array_push($data["image"], [
          thumbnail => get_image($item, [
            [name => 'product-gallery-1920'],
            [name => 'product-gallery-1024', media => "1023.98"],
          ]),
          full => get_image($item, [
            [name => 'product-gallery-full-1920']
          ])
        ]);
      }

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
        [name => 'capture_point_1920'],
        [name => 'capture_point_1024', media => "1023.98"],
      ]);

      // Meta Page
      $data["meta"] = get_field("meta_data");

      // Products
      $compilation = get_field("compilation");

      $data["products"]["is"] = $compilation['is'];
      $data["products"]["data"]["label"] = $compilation['label'];
      $data["products"]["data"]["title"] = $compilation['title'];
      $data["products"]["items"] = [];

      if($compilation['items']) {
        $args_products = array(
          'post_type' => 'post',
          'posts_per_page' => 4,
          'post__in' => $compilation['items']
        );

        $the_query_products = new WP_Query( $args_products );

        if ( $the_query_products->have_posts() ) {
          while ( $the_query_products->have_posts() ) {
            $the_query_products->the_post();

            $description = get_field("description");
            $preview = get_field('card');

            array_push($data["products"]["items"], [
              'slug' => get_post_field('post_name'),
              'title' => $description['name'],
              'tags' => $description['metka'],
              'price' => $description['price'],
              'type' => $preview['description_1'],
              'collecting' => $preview['description_2'],
              'image' => get_image($preview['image'], [
                [name => 'product-thumbnail-1920']
              ]),
            ]);
          }
        }
      }
    }

    wp_reset_postdata();
  } else {
    return new WP_REST_Response($data->errors, 404);
  }

  return $data;
}

// Получение Новости
function news_single( WP_REST_Request $request ) {
  $data = [];

  if(empty($request -> get_param('slug'))) {
    return new WP_REST_Response($data->errors, 404);
  }

  // Формируем данные
  $args = array(
    'name' => $request -> get_param('slug'),
    'post_type' => 'news'
  );

  $the_query = new WP_Query( $args );

  if ( $the_query->have_posts() ) {
    while ( $the_query->have_posts() ) {
      $the_query->the_post();

      // Header, Article
      $article = get_field("article");

      $data["header"]["data"]["label"] = $article['label'];
      $data["header"]["data"]["title"] = $article['title'];
      $data["header"]["data"]["nameTitle"] = get_the_title();
      $data["content"]["title"] = $article['title2'];
      $data["content"]["image_1"] = get_image($article['image1'], [
        [name => 'article-image-1920'],
      ]);
      $data["content"]["image_2"] = get_image($article['image2'], [
        [name => 'article-image_2-1920'],
        [name => 'article-image_2-1024', media => "1023.98"],
      ]);
      $data["content"]["image_3"] = get_image($article['image3'], [
        [name => 'article-image-1920'],
      ]);
      $data["content"]["content1"] = $article['content'];
      $data["content"]["content2"] = $article['content2'];

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
      [name => 'capture_point_1920'],
      [name => 'capture_point_1024', media => "1023.98"],
      ]);

      // Meta Page
      $data["meta"] = get_field("meta_data");

      // News
      $compilation = get_field("compilation");

      $data["news"]["is"] = $compilation['is'];
      $data["news"]["data"]["label"] = $compilation['label'];
      $data["news"]["data"]["title"] = $compilation['title'];
      $data["news"]["items"] = [];

      $args_news = array(
        'post_type' => 'news',
        'posts_per_page' => 4,
        'orderby' => 'date',
        'post__not_in' => [get_the_ID()]
      );

      $the_query_news = new WP_Query( $args_news );

      if ( $the_query_news->have_posts() ) {
        while ( $the_query_news->have_posts() ) {
          $the_query_news->the_post();
          $preview = get_field('preview');

          array_push($data["news"]["items"], [
            'slug' => get_post_field( 'post_name' ),
            'title' => $preview['title'],
            'description' => $preview['description'],
            'image' => get_image($preview['image'], []),
            'date' => get_the_date(),
          ]);

          wp_reset_postdata();
        }
      }
    }
    wp_reset_postdata();
  } else {
    return new WP_REST_Response($data->errors, 404);
  }

  return $data;
}

// Получение списка новостей
function news_list( WP_REST_Request $request ) {
  $data = [];

  // Получение параметров запроса
  $page = $request -> get_param('page')  ?? 1;
  $per_page = $request -> get_param('per_page')  ?? 8;

  // Формирование запрос
  $args = array(
    'post_type' => 'news',
    'posts_per_page' => $per_page,
    'paged' => $page,
  );

  // Получение записей
  $the_query = new WP_Query( $args );

  // Обрабатываем пагинацию
  $data['max_pages'] = (string) $the_query -> max_num_pages;
  $data['current_pages'] = $the_query -> max_num_pages >= $page ? $page : "0";
  $data['count'] = (string) $the_query -> found_posts;

  // Формирование записей
  $data['items'] = [];

  if ( $the_query->have_posts() ) {
    while ( $the_query->have_posts() ) {
      $the_query->the_post();
      $preview = get_field('preview');

      array_push($data['items'], [
        'slug' => get_post_field('post_name'),
        'title' => $preview['title'],
        'description' => $preview['description'],
        'image' => get_image($preview['image'], []),
        'date' => get_the_date(),
      ]);
    }
  } else {
    if(empty($search) && empty($tags)) {
      return new WP_REST_Response($data->errors, 404);
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение страницы - Новости
function news_page( WP_REST_Request $request ) {
  $data = [];

  // Формируем данные страницы
  $the_page = new WP_Query( ['page_id' => 955] );

  if ( $the_page->have_posts() ) {
    while ( $the_page->have_posts() ) {
      $the_page->the_post();

      // Header
      $offer = get_field("offer");

      $data["header"]['data']["title"] = $offer['title'];
      $data["header"]['data']["label"] = $offer['label'];
      $data["header"]['data']["description"] = $offer['description'];

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
        [name => 'capture_point_1920'],
        [name => 'capture_point_1024', media => "1023.98"],
      ]);

      // Meta Page
      $data["meta"] = get_field("meta_data");
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение страницы - Каталог
function catalog_page( WP_REST_Request $request ) {
  $data = [];

  // Формируем данные страницы
  $the_page = new WP_Query( ['page_id' => 556] );

  if ( $the_page->have_posts() ) {
    while ( $the_page->have_posts() ) {
      $the_page->the_post();

      // Offer
      $offer = get_field("offer");

      $data["first_screen"]["decorTitle"] = $offer['title'];
      $data["first_screen"]["label_1"] = $offer['label_1'];
      $data["first_screen"]["label_2"] = $offer['label_2'];
      $data["first_screen"]["description"] = $offer['description'];
      $data["first_screen"]["image"] = [
        image_1920 => $offer['image']['sizes']['first-screen_1920'] ? $offer['image']['sizes']['first-screen_1920'] : $offer['image']['url'],
        image_1024 => $offer['image']['sizes']['first-screen_1024'] ? $offer['image']['sizes']['first-screen_1024'] : $offer['image']['url'],
      ];

      // Categories
      $data["list"] = [];

      $categories = get_categories( array(
        'taxonomy'     => 'category',
        'type'         => 'post',
        'orderby'      => 'name',
        'order'        => 'ASC',
        'number'       => 0,
      ));

      foreach( $categories as $category ) {
        if($category->term_id == 1) continue;

        $categoryAcf = get_field("card", 'category_'.$category->term_id);

        array_push($data["list"], [
          'slug' => $category->slug,
          'title' => $categoryAcf['title_full'],
          'label' => $category->name,
          'description' => $categoryAcf['description_full'],
          'image' => get_image($categoryAcf['thumbnail_full'], [
            [name => 'categories-thumbnail-full-1920'],
            [name => 'categories-thumbnail-full-1024', media => "1023.98"],
          ])
        ]);
      }

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
        [name => 'capture_point_1920'],
        [name => 'capture_point_1024', media => "1023.98"],
      ]);

      // Meta Page
      $data["meta"] = get_field("meta_data");
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение страницы - Главная
function home_page( WP_REST_Request $request ) {
  $data = [];

  // Формируем данные страницы
  $the_page = new WP_Query( ['page_id' => 1863] );

  if ( $the_page->have_posts() ) {
    while ( $the_page->have_posts() ) {
      $the_page->the_post();
      // Offer
      $offer = get_field("offer");

      $data["first_screen"]["titleDesktop"] = $offer['title_desk'];
      $data["first_screen"]["titleMobile"] = $offer['title_mob'];
      $data["first_screen"]["label"] = $offer['label'];
      $data["first_screen"]["image_1"] = get_image($offer['image_2'], [
        [name => 'offer-1920'],
        [name => 'offer-1024', media => "1023.98"],
      ]);
      $data["first_screen"]["image_2"] = [
        image_1920 => $offer['image']['sizes']['offer-background-1920'] ? $offer['image']['sizes']['offer-background-1920'] : $offer['image']['url'],
        image_1024 => $offer['image']['sizes']['offer-background-1024'] ? $offer['image']['sizes']['offer-background-1024'] : $offer['image']['url'],
      ];

      // Categories
      $categories = get_field("categories");

      $data["categories"]["is"] = $categories['is'];
      $data["categories"]["data"]["label"] = $categories['label'];
      $data["categories"]["data"]["title"] = $categories['title'];
      $data["categories"]["data"]["description"] = $categories['description'];
      $data["categories"]["items"] = [];

      $categories = get_categories( array(
        'taxonomy'     => 'category',
        'type'         => 'post',
        'orderby'      => 'name',
        'order'        => 'DESC',
        'number'       => 0,
      ));

      foreach( $categories as $category ) {
        if($category->term_id == 1) continue;

        $categoryAcf = get_field("card", 'category_'.$category->term_id);

        array_push($data["categories"]["items"], [
          'slug' => $category->slug,
          'count' => $category->count,
          'title' => $categoryAcf['title'],
          'description' => $categoryAcf['description'],
          'image' => [
            image_1920 => $categoryAcf['thumbnail']['sizes']['categories-thumbnail-1920'] ? $categoryAcf['thumbnail']['sizes']['categories-thumbnail-1920'] : $categoryAcf['thumbnail']['url'],
          ]
        ]);
      }

      // Advantages
      $advantages = get_field("advantages");

      $data["advantages"]["is"] = $advantages['is'];
      $data["advantages"]["data"]['title'] = $advantages['title'];
      $data["advantages"]["data"]['label'] = $advantages['label'];
      $data["advantages"]["bottom"]['description'] = $advantages['description'];
      $data["advantages"]["bottom"]["link"] = [title => "Перейти в каталог", url => '/catalog'];
      $data["advantages"]["items"] = $advantages['items'];

      // About
      $about = get_field("about");

      $data["about"]["is"] = $about['is'];
      $data["about"]['label_1'] = $about['label_1'];
      $data["about"]['label_2'] = $about['label_2'];
      $data["about"]['titleDesktop'] = $about['title_decs'];
      $data["about"]['titleMobile'] = $about['title_mob'];
      $data["about"]['description'] = $about['description'];
      $data["about"]["image"] = $about['img'];
      $data["about"]["hybrids"] = array_map(fn($i) => $i['name'], $about['brands']);
      $data["about"]["user"]["name"] = $about['appeal']['worker'];
      $data["about"]["user"]["description"] = $about['appeal']['text'];
      $data["about"]["user"]["image"] = get_image($about['appeal']['image'], []);

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
        [name => 'capture_point_1920'],
        [name => 'capture_point_1024', media => "1023.98"],
      ]);

      // Meta Page
      $data["meta"] = get_field("meta_data");

      // News
      $news = get_field("news");

      $data["news"]["is"] = $news['is'];
      $data["news"]["data"]["label"] = $news['label'];
      $data["news"]["data"]["title"] = $news['title'];
      $data["news"]["data"]["description"] = $news['description'];
      $data["news"]["data"]["link"] = [title => "Больше новостей", url => '/news'];
      $data["news"]["items"] = [];

      $args_news = array(
      'post_type' => 'news',
      'posts_per_page' => 3,
      'orderby' => 'date'
      );

      $the_query_news = new WP_Query( $args_news );

      if ( $the_query_news->have_posts() ) {
        while ( $the_query_news->have_posts() ) {
          $the_query_news->the_post();
          $preview = get_field('preview');

          array_push($data["news"]["items"], [
            'slug' => get_post_field( 'post_name' ),
            'title' => $preview['title'],
            'description' => $preview['description'],
            'image' => get_image($preview['image'], [
              [name => 'news_home_1920'],
              [name => 'news_home_1024', media => "1023.98"],
            ]),
            'date' => get_the_date(),
          ]);
        }
      }
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение страницы - О компании
function about_page( WP_REST_Request $request ) {
  $data = [];

  // Формируем данные страницы
  $the_page = new WP_Query( ['page_id' => 62] );

  if ( $the_page->have_posts() ) {
    while ( $the_page->have_posts() ) {
      $the_page->the_post();

      // Offer
      $offer = get_field("offer");

      $data["first_screen"]["title"] = $offer['title'];
      $data["first_screen"]["description"] = $offer['description'];
      $data["first_screen"]["btn"] = $offer['btn'];
      $data["first_screen"]["popup"] = $offer['popup'];
      $data["first_screen"]["image"] = [
        image_1920 => $offer['img']['sizes']['first-screen_1920'] ? $offer['img']['sizes']['first-screen_1920'] : $offer['img']['url'],
        image_1024 => $offer['img']['sizes']['first-screen_1024'] ? $offer['img']['sizes']['first-screen_1024'] : $offer['img']['url'],
      ];
      // Value
      $value = get_field("value");

      $data["value"]["is"] = $value['is'];
      $data["value"]['data']["title"] = $value['title'];
      $data["value"]['data']["label"] = $value['label'];
      $data["value"]['data']["description"] = $value['description'];
      $data["value"]['image'] = get_image($value['image'], [
        [name => 'value_1920'],
        [name => 'value_1024', media => "1023.98"],
      ]);

      // Numbers
      $numbers = get_field("numbers");

      $data["numbers"]["is"] = $numbers['is'];
      $data["numbers"]["data"]['title'] = $numbers['title'];
      $data["numbers"]["data"]['description'] = $numbers['description'];
      $data["numbers"]["items"] = $numbers['items'];

      // History
      $history = get_field("history");

      $data["history"]["is"] = $history['is'];
      $data["history"]["data"]['title'] = $history['title'];
      $data["history"]["data"]['description'] = $history['description'];
      $data["history"]["items"] = [];

      foreach ($history['items'] as $key => $val) {
        array_push($data["history"]["items"], [
          year => $val['year'],
          title => $val['title'],
          description => $val['description'],
          image => get_image($val['image'], []),
        ]);
      }

       // Staff
      $staff = get_field("staff");

      $data["staff"]["is"] = $staff['is'];
      $data["staff"]["data"]['title'] = $staff['title'];
      $data["staff"]["data"]['label'] = $staff['label'];
      $data["staff"]["data"]['description'] = $staff['description'];
      $data["staff"]["items"] = [];

      foreach ($staff['items'] as $key => $val) {
        array_push($data["staff"]["items"], [
          name => $val['name'],
          post => $val['post'],
          image => get_image($val['image'], [
            [name => 'staff_1920'],
            [name => 'staff_1024', media => "1023.98"],
          ])
        ]);
      }

      // Advantages
      $principles = get_field("principles");

      $data["advantages"]["is"] = $principles['is'];
      $data["advantages"]["data"]['title'] = $principles['title'];
      $data["advantages"]["data"]['label'] = $principles['label'];
      $data["advantages"]["data"]['description'] = $principles['description'];
      $data["advantages"]["items"] = [];

      foreach ($principles['items'] as $key => $val) {
        array_push($data["advantages"]["items"], [
          title => $val['title'],
          description => $val['description'],
          image => $val['image'],
        ]);
      }

      // Partners
      $customers = get_field("customers");

      $data["partners"]["is"] = $customers['is'];
      $data["partners"]['description'] = $customers['description'];
      $data["partners"]["image"] = $customers['image'];
      $data["partners"]["items"] = array_map(fn($i) => $i['name'], $customers['items']);

      $data["partners"]["image"] = [
        image_1920 =>  $customers['image']['sizes']['partners_1920'] ? $offer['img']['sizes']['partners_1920'] : $offer['img']['url'],
        image_1024 =>  $customers['image']['sizes']['partners_1024'] ? $offer['img']['sizes']['partners_1024'] : $offer['img']['url'],
      ];

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
        [name => 'capture_point_1920'],
        [name => 'capture_point_1024', media => "1023.98"],
      ]);


      // Meta Page
      $data["meta"] = get_field("meta_data");
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение страницы - Контакты
function contacts_page( WP_REST_Request $request ) {
  $data = [];

  // Формируем данные страницы
  $the_page = new WP_Query( ['page_id' => 66] );

  if ( $the_page->have_posts() ) {
    while ( $the_page->have_posts() ) {
      $the_page->the_post();

      // Header
      $offer = get_field("offer");
      $data["header"]["data"] = $offer;

      // Main
      $main = get_field("company");

      $data["main"]["is"] = $main['is'];
      $data["main"]['items'] = [];

      foreach ($main['items'] as $key => $val) {
        array_push($data["main"]['items'], [
          image => get_image($val['image'], []),
          items => [
            ["name" => $val['post'], value => [$val['name']], type => "text"],
            ["name" => "Телефон", value =>  array_map(fn($i) => $i['text'], $val['phone']), type => "phone"],
            ["name" => "E-mail", value =>  array_map(fn($i) => $i['text'], $val['mail']), type => "mail"],
          ]
        ]);
      }

      // Region
      $region = get_field("regions");

      $data["region"]["is"] = $region['is'];
      $data["region"]['items'] = [];

      foreach ($region['items'] as $key => $val) {
        array_push($data["region"]['items'], [
          title => $val['name'],
          items => array_map(fn($item) => [
            items => [
              ["name" => $item['post'], value => [$item['name']], type => "text"],
              ["name" => "Телефон", value =>  array_map(fn($i) => $i['text'], $item['phone']), type => "phone"],
              ["name" => "E-mail", value =>  array_map(fn($i) => $i['text'], $item['mail']), type => "mail"],
            ]
          ], $val['contacts'])
        ]);
      }

      // Distributors
      $distributors = get_field("distributors");

      $data["distributors"]["is"] = $distributors['is'];
      $data["distributors"]["title"] = $distributors['title'];
      $data["distributors"]["items"] = [];

      foreach ($distributors['items'] as $key => $val) {
        array_push($data["distributors"]["items"], [
          items => [
            ["name" => $val['region'], value => [$val['name']], type => "text"],
            ["name" => "Почтовый адрес", value => [$val['address']], type => "text"],
            ["name" => "Телефон", value =>  array_map(fn($i) => $i['text'], $val['phone']), type => "phone"],
            ["name" => "E-mail", value =>  array_map(fn($i) => $i['text'], $val['mail']), type => "mail"],
          ]
        ]);
      }

      // Requisites
      $requisites = get_field("requisites");

      $data["requisites"]["is"] = $requisites['is'];
      $data["requisites"]["title"] = $requisites['title'];
      $data["requisites"]["items"] = [
        [
          "title" => $requisites['company_title'],
          "items" => [
            ["name" => "ИНН", value => [$requisites['company_inn']], type => "text"],
            ["name" => "КПП", value => [$requisites['company_kpp']], type => "text"],
            ["name" => "Юридический адрес", value => [$requisites['company_legal_address']], type => "text"],
            ["name" => "Фактический адрес", value => [$requisites['company_actual_address']], type => "text"],
            ["name" => "Телефон", value => [$requisites['company_phone']], type => "phone"],
            ["name" => "Сайт", value => [$requisites['company_website']], type => "link"],
            ["name" => "E-mail", value => [$requisites['company_mail']], type => "mail"],
            ["name" => "E-mail", value => [$requisites['company_mail2']], type => "mail"],
            ["name" => "ОКПО", value => [$requisites['company_okpo']], type => "text"],
            ["name" => "ОКВЭД", value => [$requisites['company_okved']], type => "text"],
            ["name" => "ОКТМО", value => [$requisites['company_oktmo']], type => "text"],
            ["name" => "ОГРН", value => [$requisites['company_ogrn']], type => "text"],
            ["name" => "Свидетельство о постановке на учет выдано", value => [$requisites['company_the_certificate_of_registration']], type => "text"],
          ],
        ],
        [
          "title" => $requisites['bank_title'],
          "items" => [
            ["name" => $requisites['bank_name'], value => [$requisites['bank_payment_account']], type => "text"],
            ["name" => "Кор. счет", value => [$requisites['bank_correspondent_account']], type => "text"],
            ["name" => "БИК", value => [$requisites['bank_bic']], type => "text"],
            ["name" => "ИНН", value => [$requisites['bank_inn']], type => "text"],
            ["name" => "ОКПО", value => [$requisites['bank_okpo']], type => "text"],
            ["name" => "ОГРН", value => [$requisites['bank_ogrn']], type => "text"],
            ["name" => "ОКВЭД", value => [$requisites['bank_okved']], type => "text"],
            ["name" => "КПП", value => [$requisites['bank_kpp']], type => "text"],
            ["name" => "Юр. Адрес", value => [$requisites['bank_legal_address']], type => "text"],
            ["name" => "Генеральный директор, действует на основании Устава", value => [$requisites['bank_legal_entity']], type => "text"],
          ],
        ]
      ];

      // Capture Point
      $capture_point = get_field("capture_point");

      $data["capture_point"]["is"] = $capture_point['is'];
      $data["capture_point"]["data"]["title"] = $capture_point['title'];
      $data["capture_point"]["data"]["label"] = $capture_point['label'];
      $data["capture_point"]["data"]["description"] = $capture_point['subtitle'];
      $data["capture_point"]["data"]["button"] = $capture_point['btn'];
      $data["capture_point"]["data"]["popup"] = $capture_point['popup'];

      $data["capture_point"]["image"] = get_image($capture_point['image'], [
        [name => 'capture_point_1920'],
        [name => 'capture_point_1024', media => "1023.98"],
      ]);


      // Meta Page
      $data["meta"] = get_field("meta_data");
    }
  }

  wp_reset_postdata();

  return $data;
}

// Получение страницы - Widget
function widget_page( WP_REST_Request $request ) {
  $data = [];

  // Формируем данные страницы
  $the_page = new WP_Query( ['page_id' => 68] );

  if ( $the_page->have_posts() ) {
    while ( $the_page->have_posts() ) {
      $the_page->the_post();

      $data['header_title'] = get_field("header_phone");
      $data['footer_phone'] = get_field("footer_phone");
      $data['footer_mail'] = get_field("footer_mail");
      $data['footer_сopyright'] = get_field("footer_сopyright");
    }
  }

  wp_reset_postdata();

  return $data;
}